(function ($) {
  function setTestResult(msg, ok) {
    var el = $('#suggent_bp_test_result');
    el.removeClass('ok err');
    if (ok) { el.addClass('ok'); } else { el.addClass('err'); }
    el.text(msg || '');
  }

  function fetchBots() {
    setTestResult('Loading bots...', true);
    $.post(SUGGENT_BP.ajaxUrl, {
      action: 'suggent_bp_fetch_bots',
      nonce: SUGGENT_BP.nonce
    }).done(function (res) {
      if (!res || !res.success) {
        setTestResult(SUGGENT_BP.strings.botError, false);
        return;
      }
      var data = res.data && res.data.data ? res.data.data : res.data;
      var bots = data.bots || [];
      var select = $('#suggent_bp_default_bot');
      var current = select.data('current');
      select.empty();
      select.append('<option value="">-- Select a bot --</option>');
      bots.forEach(function (bot) {
        var opt = $('<option/>').val(bot.id).text(bot.name + (bot.active ? '' : ' (inactive)'));
        if (String(bot.id) === String(current) || bot.is_default) opt.prop('selected', true);
        select.append(opt);
      });
      setTestResult('Bots loaded.', true);
    }).fail(function () {
      setTestResult(SUGGENT_BP.strings.botError, false);
    });
  }

  $(function () {
    var select = $('#suggent_bp_default_bot');
    if (select.length) {
      select.data('current', select.data('current') || '');
    }

    $('#suggent_bp_test').on('click', function () {
      setTestResult('Testing...', true);
      $.post(SUGGENT_BP.ajaxUrl, {
        action: 'suggent_bp_test',
        nonce: SUGGENT_BP.nonce
      }).done(function (res) {
        if (res && res.success) {
          var name = res.data && res.data.data && res.data.data.bot ? res.data.data.bot.name : '';
          setTestResult(name ? ('Connected to ' + name) : 'Connection ok.', true);
        } else {
          var msg = res && res.data && res.data.message ? res.data.message : SUGGENT_BP.strings.testError;
          setTestResult(msg, false);
        }
      }).fail(function () {
        setTestResult(SUGGENT_BP.strings.testError, false);
      });
    });

    $('#suggent_bp_refresh_bots').on('click', function () {
      fetchBots();
    });

    if ($('#suggent_bp_default_bot').length) {
      fetchBots();
    }
  });
})(jQuery);
