<?php
if (!defined('ABSPATH')) exit;

class Suggent_Bot_Panel_Embed {
    private $option_key;

    public function __construct($option_key) {
        $this->option_key = $option_key;
    }

    public function hooks() {
        add_shortcode('suggent_chat', [$this, 'shortcode']);
        add_action('wp_footer', [$this, 'maybe_global_embed']);
    }

    public function shortcode($atts = []): string {
        $settings = suggent_bp_get_settings($this->option_key);
        $atts = shortcode_atts([
            'bot_id' => $settings['default_bot_id'],
            'theme_color' => $settings['theme_color'],
            'position' => $settings['position'],
        ], $atts);

        return $this->render_embed($settings, $atts);
    }

    public function maybe_global_embed(): void {
        $settings = suggent_bp_get_settings($this->option_key);
        if (($settings['global_embed'] ?? 'no') !== 'yes') return;
        echo $this->render_embed($settings, [
            'bot_id' => $settings['default_bot_id'],
            'theme_color' => $settings['theme_color'],
            'position' => $settings['position'],
        ]);
    }

    private function render_embed(array $settings, array $overrides): string {
        $panel = suggent_bp_panel_url($settings);
        $key = suggent_bp_decode_widget_key((string)($settings['widget_key'] ?? ''));
        if ($panel === '' || $key === '') return '';

        $botId = trim((string)($overrides['bot_id'] ?? ''));
        $themeColor = trim((string)($overrides['theme_color'] ?? ''));
        $position = in_array(($overrides['position'] ?? 'right'), ['left','right'], true) ? $overrides['position'] : 'right';

        $cssUrl = esc_url($panel . '/public/widget/widget.css');
        $jsUrl = esc_url($panel . '/public/widget/widget.js');

        $html = '';
        $html .= '<link rel="stylesheet" href="' . $cssUrl . '" />';
        $html .= '<script data-suggent-widget="1" src="' . $jsUrl . '" defer '
            . 'data-panel-url="' . esc_attr($panel) . '" '
            . 'data-widget-key="' . esc_attr($key) . '" '
            . ($botId !== '' ? 'data-bot-id="' . esc_attr($botId) . '" ' : '')
            . ($themeColor !== '' ? 'data-theme-color="' . esc_attr($themeColor) . '" ' : '')
            . 'data-position="' . esc_attr($position) . '"></script>';
        return $html;
    }
}
