<?php
if (!defined('ABSPATH')) exit;

class Suggent_Bot_Panel_REST {
    const REST_NS = 'suggent-bot-panel/v1';

    public function hooks() {
        add_action('rest_api_init', [$this, 'register']);
    }

    public function register() {
        register_rest_route(self::REST_NS, '/products', [
            'methods' => 'GET',
            'callback' => [$this, 'products'],
            'permission_callback' => '__return_true',
            'args' => [
                'skus' => ['required' => true, 'type' => 'string'],
            ],
        ]);
    }

    public function products(WP_REST_Request $req) {
        if (!function_exists('wc_get_product_id_by_sku')) {
            return new WP_REST_Response(['ok' => false, 'error' => 'woocommerce_missing'], 400);
        }
        $skusRaw = (string)$req->get_param('skus');
        $parts = preg_split('/[\s,]+/', $skusRaw, -1, PREG_SPLIT_NO_EMPTY);
        $skus = [];
        foreach ($parts as $sku) {
            $s = strtoupper(trim((string)$sku));
            if ($s !== '') $skus[] = $s;
        }
        $skus = array_values(array_unique($skus));
        $items = [];
        foreach ($skus as $sku) {
            $id = wc_get_product_id_by_sku($sku);
            if (!$id) continue;
            $product = wc_get_product($id);
            if (!$product) continue;
            $imageId = $product->get_image_id();
            $imageUrl = $imageId ? wp_get_attachment_image_url($imageId, 'medium') : '';
            $items[] = [
                'id' => $product->get_id(),
                'sku' => $product->get_sku(),
                'name' => $product->get_name(),
                'permalink' => $product->get_permalink(),
                'price_html' => $product->get_price_html(),
                'regular_price' => $product->get_regular_price(),
                'sale_price' => $product->get_sale_price(),
                'in_stock' => $product->is_in_stock(),
                'image' => $imageUrl,
                'add_to_cart_url' => $product->add_to_cart_url(),
            ];
        }
        return new WP_REST_Response(['ok' => true, 'products' => $items], 200);
    }
}
