<?php
if (!defined('ABSPATH')) exit;

function suggent_bp_default_settings(): array {
    return [
        'widget_key' => '',
        'default_bot_id' => '',
        'theme_color' => '#22c7a6',
        'position' => 'right',
        'global_embed' => 'no',
    ];
}

function suggent_bp_get_settings(string $option_key): array {
    $saved = get_option($option_key);
    $defaults = suggent_bp_default_settings();
    if (!is_array($saved)) {
        return $defaults;
    }
    return array_merge($defaults, $saved);
}

function suggent_bp_save_settings(string $option_key, array $settings): void {
    update_option($option_key, $settings);
}

function suggent_bp_decode_widget_key(string $value): string {
    $value = trim($value);
    if ($value === '') return '';
    $decoded = base64_decode($value, true);
    if (is_string($decoded) && $decoded !== '') {
        return $decoded;
    }
    return $value;
}

function suggent_bp_panel_url(array $settings): string {
    return 'https://my.suggent.com';
}

function suggent_bp_call_panel(string $panel_url, string $path, string $widget_key, array $body = []): array {
    $widget_key = (string)$widget_key;
    if ($widget_key === '') return [false, 'Missing widget key'];
    $url = rtrim($panel_url, '/') . $path;
    $response = wp_remote_post($url, [
        'timeout' => 12,
        'headers' => [
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $widget_key,
            'X-Widget-Server' => '1',
        ],
        'body' => wp_json_encode($body),
    ]);
    if (is_wp_error($response)) {
        return [false, $response->get_error_message()];
    }
    $code = wp_remote_retrieve_response_code($response);
    $raw = wp_remote_retrieve_body($response);
    $data = json_decode($raw, true);
    if ($code >= 200 && $code < 300) {
        return [true, is_array($data) ? $data : []];
    }
    $error = is_array($data) && isset($data['error']) ? $data['error'] : 'Request failed';
    return [false, $error];
}
