<?php
/**
 * Plugin Name: Suggent Product Suggestions
 * Description: Connect your WordPress site to Suggent bots and embed the chat widget.
 * Version: 1.2.0
 * Author: Suggent
 * Author URI: https://suggent.com
 * Text Domain: suggent-bot-panel
 */

if (!defined('ABSPATH')) exit;

define('SUGGENT_BP_VERSION', '1.2.0');
define('SUGGENT_BP_SLUG', 'suggent-bot-panel');
define('SUGGENT_BP_PATH', plugin_dir_path(__FILE__));
define('SUGGENT_BP_URL', plugin_dir_url(__FILE__));

define('SUGGENT_BP_OPTION', 'suggent_bot_panel_settings_v1');

// Embedded data binder
define('SUGGENT_DB_VERSION', '2.0.0');
define('SUGGENT_DB_SLUG', 'suggent-data-binder');
define('SUGGENT_DB_PATH', SUGGENT_BP_PATH);
define('SUGGENT_DB_URL', SUGGENT_BP_URL);

// Define binder constants expected by embedded binder files.
if (!defined('OTTO_DB_VERSION')) define('OTTO_DB_VERSION', SUGGENT_DB_VERSION);
if (!defined('OTTO_DB_SLUG')) define('OTTO_DB_SLUG', SUGGENT_DB_SLUG);
if (!defined('OTTO_DB_PATH')) define('OTTO_DB_PATH', SUGGENT_DB_PATH);
if (!defined('OTTO_DB_URL')) define('OTTO_DB_URL', SUGGENT_DB_URL . 'assets/otto-data-binder/');

// Minimal wrapper for embedded binder constants
if (!class_exists('OTTO_Data_Binder')) {
    class OTTO_Data_Binder {
        const OPTION_KEY = 'otto_data_binder_settings_v2';
        const CRON_BASE  = 'otto_data_binder_generate_template_';
    }
}

require_once SUGGENT_BP_PATH . 'includes/suggent-bot-panel-helpers.php';
require_once SUGGENT_BP_PATH . 'includes/class-suggent-bot-panel-admin.php';
require_once SUGGENT_BP_PATH . 'includes/class-suggent-bot-panel-embed.php';
require_once SUGGENT_BP_PATH . 'includes/class-suggent-bot-panel-rest.php';
require_once SUGGENT_BP_PATH . 'includes/otto-data-binder-helpers.php';
require_once SUGGENT_BP_PATH . 'includes/class-otto-data-binder-admin.php';
require_once SUGGENT_BP_PATH . 'includes/class-otto-data-binder-generator.php';
require_once SUGGENT_BP_PATH . 'includes/class-otto-data-binder-rest.php';

class Suggent_Bot_Panel {
    public function __construct() {
        add_action('plugins_loaded', [$this, 'init']);
        register_activation_hook(__FILE__, [$this, 'activate']);
    }

    public function init() {
        $admin = new Suggent_Bot_Panel_Admin(SUGGENT_BP_OPTION);
        $admin->hooks();

        $embed = new Suggent_Bot_Panel_Embed(SUGGENT_BP_OPTION);
        $embed->hooks();

        $rest = new Suggent_Bot_Panel_REST();
        $rest->hooks();

        $binderAdmin = new OTTO_Data_Binder_Admin(OTTO_Data_Binder::OPTION_KEY, OTTO_Data_Binder::CRON_BASE, SUGGENT_BP_SLUG);
        $binderAdmin->hooks();

        $binderGenerator = new OTTO_Data_Binder_Generator(OTTO_Data_Binder::OPTION_KEY, OTTO_Data_Binder::CRON_BASE);
        $binderGenerator->hooks();

        $binderRest = new OTTO_Data_Binder_REST(OTTO_Data_Binder::OPTION_KEY, OTTO_Data_Binder::CRON_BASE);
        $binderRest->hooks();
    }

    public function activate() {
        $settings = suggent_bp_get_settings(SUGGENT_BP_OPTION);
        update_option(SUGGENT_BP_OPTION, $settings);

        $dbSettings = otto_db_get_settings(OTTO_Data_Binder::OPTION_KEY);
        otto_db_ensure_output_dir($dbSettings['output_dir']);
        otto_db_reschedule_all_templates(OTTO_Data_Binder::CRON_BASE, $dbSettings['templates']);
        update_option(OTTO_Data_Binder::OPTION_KEY, $dbSettings);
    }
}

new Suggent_Bot_Panel();
